IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_ACERTO_CUSTO_TRIB_EXEC_ALL]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_PROD_CPL_ACERTO_CUSTO_TRIB_EXEC_ALL];
GO

GO
--EXEC P_EST_PROD_CPL_ACERTO_CUSTO_TRIB_EXEC_ALL
CREATE PROCEDURE P_EST_PROD_CPL_ACERTO_CUSTO_TRIB_EXEC_ALL
WITH ENCRYPTION
AS
	  DECLARE @CD_FILIAL INT;
      DECLARE FILIAIS CURSOR FAST_FORWARD FOR
		  select distinct cd_filial 
		  from EST_PROD_CPL_ACERTO_CUSTO_PENDENTE

	   OPEN FILIAIS;
	   FETCH NEXT FROM FILIAIS INTO @CD_FILIAL;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT '  Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
			 
			 EXEC P_EST_PROD_CPL_ACERTO_CUSTO_TRIB  @CD_FILIAL;
			 FETCH NEXT FROM FILIAIS INTO @CD_FILIAL ;
		  END ;

	   CLOSE FILIAIS ;
	   DEALLOCATE FILIAIS ;

	 

